<?php 
require_once '../conexiones/conexion.php';

// Habilitar errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Procesar la acción de editar un usuario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_user'])) {
    $usuario_id = $_POST['user_id'];
    $email = $_POST['email'];
    $role = $_POST['role'];

    // Validar datos básicos
    if (filter_var($email, FILTER_VALIDATE_EMAIL) && in_array($role, ['admin', 'user']) && is_numeric($usuario_id)) {
        // Verificar si el usuario existe
        $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE id = ?");
        $stmt->execute([$usuario_id]);
        if ($stmt->rowCount() > 0) {
            // Actualizar los datos del usuario
            $stmt = $pdo->prepare("UPDATE usuarios SET email = ?, role = ? WHERE id = ?");
            $stmt->execute([$email, $role, $usuario_id]);

            // Redirigir inmediatamente con un código 303
            header('Location: ../usuarios.php', true, 303);
            exit;
        } else {
            // Mostrar error y redirigir después de 3 segundos
            echo "Error: Usuario no encontrado.";
            header('Refresh: 3; URL=../usuarios.php');
            exit;
        }
    } else {
        // Mostrar error y redirigir después de 3 segundos
        echo "Error: Datos inválidos.";
        header('Refresh: 3; URL=../usuarios.php');
        exit;
    }
}

// Si se accede directamente al archivo, redirigir a la lista de usuarios
header('Location: ../usuarios.php', true, 303);
exit;
?>
